<?php
/**
 * ============================================================================
 * FILE 3: includes/header.php (Page Header - Desktop)
 * ============================================================================
 */
?>
<!-- Top Navigation Bar -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="<?php echo APP_URL; ?>/dashboard/">
            <span class="fs-3 me-2">🌾</span>
            <span class="fw-bold text-success">AIMS</span>
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarMain">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo APP_URL; ?>/dashboard/">
                        <i class="bi bi-speedometer2 me-1"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo APP_URL; ?>/marketplace/">
                        <i class="bi bi-shop me-1"></i> Marketplace
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo APP_URL; ?>/prices/">
                        <i class="bi bi-graph-up me-1"></i> Prices
                    </a>
                </li>
                <?php if (getUserType() === 'farmer'): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo APP_URL; ?>/farm/">
                        <i class="bi bi-tree me-1"></i> My Farm
                    </a>
                </li>
                <?php endif; ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo APP_URL; ?>/chat/">
                        <i class="bi bi-chat-dots me-1"></i> Messages
                        <span class="badge bg-danger rounded-pill ms-1" id="unreadMessagesCount"></span>
                    </a>
                </li>
            </ul>
            
            <ul class="navbar-nav">
                <!-- Notifications -->
                <li class="nav-item dropdown">
                    <a class="nav-link position-relative" href="#" id="notificationsDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="bi bi-bell fs-5"></i>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" id="notificationsBadge">
                            0
                        </span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" style="width: 350px; max-height: 400px; overflow-y: auto;">
                        <li><h6 class="dropdown-header">Notifications</h6></li>
                        <li><hr class="dropdown-divider"></li>
                        <li id="notificationsList">
                            <div class="text-center py-3 text-muted">
                                <i class="bi bi-bell-slash fs-3"></i>
                                <p class="mb-0">No new notifications</p>
                            </div>
                        </li>
                    </ul>
                </li>
                
                <!-- User Profile -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                        <img src="<?php echo getAvatarUrl($_SESSION['profile_picture'] ?? null); ?>" alt="Profile" class="rounded-circle me-2" width="35" height="35">
                        <span><?php echo getUserName(); ?></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?php echo APP_URL; ?>/profile/">
                            <i class="bi bi-person me-2"></i> My Profile
                        </a></li>
                        <li><a class="dropdown-item" href="<?php echo APP_URL; ?>/profile/settings.php">
                            <i class="bi bi-gear me-2"></i> Settings
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <?php if (getUserType() === 'admin'): ?>
                        <li><a class="dropdown-item" href="<?php echo APP_URL; ?>/admin/">
                            <i class="bi bi-shield-lock me-2"></i> Admin Panel
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item text-danger" href="#" onclick="logout(); return false;">
                            <i class="bi bi-box-arrow-right me-2"></i> Logout
                        </a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>
